/**
 *  \file sha256_fpga.h
 *  \author Maurizio di Lorenzo, Gianluca Roascio
 *  \brief High-level driver for communication between CPU and SHA256 IP core in an IP-Manager-based environment
 */

#ifndef SHA256_FPGA_H_
#define SHA256_FPGA_H_

#include <stdint.h>
#include <string.h>
#include "Fpgaipm.h"

// types
#define SHA256_FPGA_RETURN_CODE int8_t

/** \defgroup shaRet256 SHA256_FPGA return values
 * @{
 */
/** \name SHA256_FPGA return values */
///@{
#define SHA256_FPGA_RES_OK				 ( 0)
#define SHA256_FPGA_RES_INVALID_ARGUMENT (-1)
///@}
/** @} */


// public function

/**
 * @brief Compute the SHA256 algorithm on input data depending on the current status of the SHA256_FPGA context.
 * @param message Pointer to the input data.
 * @param dataLen Bytes to be processed.
 * @param digest Pointer to a blank memory area that can store the computed output digest.
 * @return See \ref shaRet256.
 */
SHA256_FPGA_RETURN_CODE SHA256_FPGA_digest_message (const uint8_t *message, uint64_t dataLen, uint8_t *digest);

#endif /* SHA256_FPGA_H_ */
